`.htaccess` is a configuration file executed by Apache.  It can be used for everything from basic traffic redirection, password protection, to image hot link prevention.  To enable htaccess, modify `/etc/apache2/sites-enabled/default-ssl.conf`.

Directly underneath the closing `</VirtualHost>` tag, add a new `<Directory>` block with the following content:

<Directory /var/www/html/>
    Options Indexes FollowSymLinks MultiViews
    AllowOverride All
    Require all granted
</Directory>

  

We also want to add `SSLProxyEngine on` underneath `SSLEngine on`.

After those changes have been saved, restart apache for everything to take effect.

ubuntu@redirector-1 ~> sudo systemctl restart apache2

  

You can also overwrite the default index page to provide content for testing, without flooding the console each time with the default apache page.

ubuntu@redirector-1 ~> echo "Hello from Apache" | sudo tee /var/www/html/index.html 

  

Next, create a new `.htaccess` file in the Apache web root, `/var/www/html` and enter the following:

RewriteEngine on
RewriteRule ^test$ index.html [NC]

  

The first line, unsurprisingly, enables the rewrite engine.  The second is a simple redirect rule.  The syntax of the rule is: `pattern substitution [flags]`.

In this case, the pattern is `^test$`.  This is a regular expression which looks for the beginning of a line (`^`), followed by the string `test`, followed by the end of a line (`$`).  The substitution is the new destination - in this example it's index.html on our local server, but you can redirect to an external domain as well.

The `[NC]` flag tells Apache to ignore case, so both "test" and "TEST" will match.

 Use curl to access this non-existing page.

ubuntu@redirector-1 ~> curl -k https://localhost/test
Hello from Apache

  

Even though "test" does not exist as a file in the web root, Apache interprets this redirect rule and serves index.html instead.

Multiple flags can be used with the syntax `[Flag1,Flag2,FlagN]`.  Other useful flags include:

-   [L] - Last.  Tells `mod_rewrite` to stop processing further rules.
-   [NE] - No Escape.  Don't encode special characters (e.g. `&` and `?`) to their hex values.
-   [P] - Proxy.  Handle the request with `mod_proxy`.
-   [R] - Redirect.  Send a redirect code in response.
-   [S] - Skip.  Skip the next N number of rules.
-   [T] - Type.  Sets the MIME type of the response.

In addition, rewrite conditions (**RewriteCond**) can be combined with RewriteRule. These allow rewrite rules to only be applied under certain conditions (hence the name). The syntax is: `TestString Condition [Flags]`.

TestString can be static but also a variable, such as `%{REMOTE_ADDR}`, `%{HTTP_COOKIE}`, `${HTTP_USER_AGENT}`, `%{REQUEST_URI}` and more.

Multiple RewriteCond rules can be defined which are treated like ANDs by default, but can be treated as OR with an [OR] flag.  You can have multiple RewriteCond and RewriteRule directives and they are evaluated top-to-bottom.

We'll cover several examples next, but the mod_rewrite [documentation](https://httpd.apache.org/docs/2.4/mod/mod_rewrite.html) is the best place to check for full details.

